/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.TimeOrReferenceSycnPanel;
import DE.siemens.ad.logo.dialog.comp.TimeParameterJPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ComfortSwitchParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.panel.Time2ProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComfortSwitchPanel
extends Time2ProtectionPanel
implements PropertyChangeListener,
ItemListener {
    private JCheckBox fUseDefault;
    private TimeOrReferenceSycnPanel fTimeToWarning;
    private BorderJPanel fTimeToWarningBorder;
    private JLabel fTimeToWarningLabel;
    private TimeOrReferenceSycnPanel fWarningTime;
    private BorderJPanel fWarningTimeBorder;
    private JLabel fWarningTimeLabel;
    private TimeUnit fTimeUnit;

    public ComfortSwitchPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.addComponents();
        if (!((BlockParameter)parameterReference).getBlock().getWiringDiagram().getHardware().supports("comfortSwitchResetWarning")) {
            this.setAdditionalComponents(false);
        }
    }

    private void addComponents() {
        this.paramPane.setLayout(new BoxLayout(this.paramPane, 1));
        JPanel panel = new JPanel(new FlowLayout(0));
        this.fUseDefault = new JCheckBox();
        this.fUseDefault.addActionListener(new UseDefaultButtonListener());
        panel.add(this.fUseDefault);
        this.paramPane.add(panel);
        ComfortSwitchParameter param = (ComfortSwitchParameter)this.fParameterReference;
        Hardware hw = param.getBlock().getHardware();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
        Timer timerToWarning = param.getTimerToWarning();
        timerToWarning.convertTimerTo(availableTimeUnits);
        Block lBlock = param.getBlock();
        this.fTimeToWarning = new TimeOrReferenceSycnPanel(timerToWarning);
        this.fTimeToWarning.setName("TimerToWarning");
        this.fTimeToWarning.setBounds(17, 106, 291, 60);
        this.fTimeToWarning.setReferenceList(lBlock.getWiringDiagram().getBlocksForReference(lBlock, true));
        this.fTimeToWarning.setReferenceVisability(param.isValueOrReference());
        this.fTimeToWarningBorder = new BorderJPanel(new FlowLayout(0));
        this.fTimeToWarningBorder.add(this.fTimeToWarning);
        this.paramPane.add(this.fTimeToWarningBorder);
        this.fTimeToWarningLabel = new JLabel();
        this.fTimeToWarningLabel.setAlignmentX(0.0f);
        this.fTimeToWarningBorder.add((Component)this.fTimeToWarningLabel, "East");
        Timer warningTimer = param.getWarningTimer();
        warningTimer.convertTimerTo(availableTimeUnits);
        this.fWarningTime = new TimeOrReferenceSycnPanel(warningTimer);
        this.fWarningTime.setName("WarningTimer");
        this.fWarningTime.setBounds(17, 106, 291, 60);
        this.fWarningTime.setReferenceList(lBlock.getWiringDiagram().getBlocksForReference(lBlock, true));
        this.fWarningTime.setReferenceVisability(param.isValueOrReference());
        this.fWarningTimeBorder = new BorderJPanel(new FlowLayout(0));
        this.fWarningTimeBorder.add(this.fWarningTime);
        this.paramPane.add(this.fWarningTimeBorder);
        this.fWarningTimeLabel = new JLabel();
        this.fWarningTimeLabel.setAlignmentX(0.0f);
        this.fWarningTimeBorder.add((Component)this.fWarningTimeLabel, "East");
        this.getHighTime().addPropertyChangeListener(TimeParameterJPanel.TIME_UNIT_CHANGE_EVENT_NAME, this);
        this.getHighTime().addReferenceTimeUnitChangedListener(this);
    }

    public boolean checkChanged() {
        if (super.checkChanged()) {
            return true;
        }
        if (this.fTimeToWarning.checkChanged()) {
            return true;
        }
        return this.fWarningTime.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!super.checkFieldContents()) {
            return false;
        }
        if (!this.fWarningTime.checkFieldContents()) {
            return false;
        }
        return this.fTimeToWarning.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        ComfortSwitchParameter param = (ComfortSwitchParameter)this.fParameterReference;
        this.fTimeToWarning.loadFieldContents();
        this.fWarningTime.loadFieldContents();
        this.fTimeUnit = param.getHTimer().getParamTime();
        boolean useDefaultWarningValues = param.isDefaultWarningUsed();
        this.fUseDefault.setSelected(useDefaultWarningValues);
        this.setWarningInputs(!useDefaultWarningValues);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fTimeUnit = (TimeUnit)evt.getNewValue();
        this.setTimeUnits();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JComboBox && e.getStateChange() == 1 && e.getItem() instanceof TimeUnit) {
            this.fTimeUnit = (TimeUnit)e.getItem();
            this.setTimeUnits();
        }
    }

    private void setTimeUnits() {
        this.setWarningLabels(this.fTimeUnit);
        if (this.fUseDefault.isSelected()) {
            this.setDefaultWarningValues();
        }
    }

    private void setAdditionalComponents(boolean visible) {
        this.fUseDefault.setVisible(visible);
        this.fTimeToWarningBorder.setVisible(visible);
        this.fWarningTimeBorder.setVisible(visible);
    }

    protected void setDefaultWarningValues() {
        this.fTimeToWarning.setReferenceAndButton(false);
        this.fTimeToWarning.setTimeUnit(this.getDefaultTimeUnit());
        this.fWarningTime.setReferenceAndButton(false);
        this.fWarningTime.setTimeUnit(this.getDefaultTimeUnit());
    }

    public void setLabels() {
        super.setLabels();
        this.fUseDefault.setText(Language.getString("stairsSwitch.useDefaultWarningproperties", "Use default Warning"));
        this.fTimeToWarningBorder.setTitle(Language.getString("stairsSwitch.timeToWarning.borderTitle", "Time to warning"));
        this.fWarningTimeBorder.setTitle(Language.getString("stairsSwitch.warningTime.borderTitle", "Warningtime"));
    }

    private void setWarningInputs(boolean enable) {
        this.fTimeToWarningBorder.setEnabled(enable);
        this.fWarningTimeBorder.setEnabled(enable);
    }

    private void setWarningLabels(TimeUnit value) {
        this.fTimeToWarning.setTimeUnitKey(value);
        this.fWarningTime.setTimeUnitKey(value);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ComfortSwitchParameter param = (ComfortSwitchParameter)this.fParameterReference;
        Timer timer = param.getTimerToWarning();
        timer.setParamTime(0, 0, this.fTimeUnit.getUnitKey());
        this.fTimeToWarning.storeFieldContents();
        timer = param.getWarningTimer();
        timer.setParamTime(this.fTimeUnit);
        this.fWarningTime.storeFieldContents();
    }

    private TimeUnit getDefaultTimeUnit() {
        return TimeUnit.getNewTimeObject(this.fTimeUnit.getUnitKey());
    }

    public class UseDefaultButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            if (ComfortSwitchPanel.this.fUseDefault.isSelected()) {
                ComfortSwitchPanel.this.setDefaultWarningValues();
                ComfortSwitchPanel.this.setWarningInputs(false);
            } else {
                ComfortSwitchPanel.this.setWarningInputs(true);
            }
        }
    }
}

